#   Convoy is a WSGI app for loading multiple files in the same request.
#   Copyright (C) 2010-2012  Canonical, Ltd.
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU Affero General Public License as
#   published by the Free Software Foundation, either version 3 of the
#   License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU Affero General Public License for more details.
#
#   You should have received a copy of the GNU Affero General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os

from convoy.combo import combo_app

def application(environ, start_response):
    # CONVOY_ROOT may be set by SetEnv in Apache configuration, in which
    # case mod_wsgi passes it in the request environment.  (This is safe
    # because HTTP headers end up in HTTP_*.)
    root = environ.get('CONVOY_ROOT')
    if root is None:
        # Alternatively, convoy may be run under a standalone WSGI server
        # such as gunicorn, in which case we need to look for CONVOY_ROOT in
        # the process environment.
        root = os.environ.get('CONVOY_ROOT', '/srv/launchpad.dev/convoy')
    app = combo_app(root)
    return app(environ, start_response)
