/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2007 Eike Hein <hein@kde.org>
*/


#include "general_settings.h"
#include "general_settings.moc"

#include <tqapplication.h>
#include <tqslider.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqlabel.h>

#include <knuminput.h>
#include <klocale.h>


GeneralSettings::GeneralSettings(TQWidget* parent, const char* name)
 : GeneralSettingsUI(parent, name)
{
    kcfg_width->setSuffix("%");
    kcfg_height->setSuffix("%");
    steps_spinbox->setPrefix("~");
    steps_spinbox->setSuffix("ms");

    for (int i = 2; i <= TQApplication::desktop()->numScreens(); i++)
        kcfg_screen->insertItem(i18n("Screen %1").tqarg(TQString::number(i)));

    if (TQApplication::desktop()->numScreens() > 1)
    {
        screen_label->setEnabled(true);
        kcfg_screen->setEnabled(true);
    }

    connect(kcfg_width, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateWidthSlider(int)));
    connect(width_slider, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateWidthSpinbox(int)));

    connect(kcfg_height, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateHeightSlider(int)));
    connect(height_slider, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateHeightSpinbox(int)));

    connect(kcfg_steps, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateStepsSpinbox(int)));
    connect(steps_spinbox, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateStepsSlider(int)));

    connect(kcfg_location, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateLocation(int)));
}

GeneralSettings::~GeneralSettings()
{
}

void GeneralSettings::updateWidthSlider(int width)
{
    width_slider->setValue(width/10);

    emit updateSize(width, kcfg_height->value(), kcfg_location->value());
}

void GeneralSettings::updateWidthSpinbox(int width)
{
    kcfg_width->setValue(width*10);
}

void GeneralSettings::updateHeightSlider(int height)
{
    height_slider->setValue(height/10);

    emit updateSize(kcfg_width->value(), height, kcfg_location->value());
}

void GeneralSettings::updateHeightSpinbox(int height)
{
    kcfg_height->setValue(height*10);
}

void GeneralSettings::updateStepsSlider(int speed)
{
    kcfg_steps->setValue(speed/10);
}

void GeneralSettings::updateStepsSpinbox(int speed)
{
    steps_spinbox->setValue(speed*10);
}

void GeneralSettings::updateLocation(int location)
{
    emit updateSize(kcfg_width->value(), kcfg_height->value(), location);
}
