/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2007 Eike Hein <hein@kde.org>
*/


#ifndef SESSION_H
#define SESSION_H

#include "terminal_splitter.h"

#include <tqobject.h>
#include <tqwidget.h>


class Terminal;
class TerminalInterface;
class TerminalFocusWatcher;

class Session : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

    public:
        enum SessionType { Single, TwoHorizontal, TwoVertical, Quad };

        explicit Session(TQWidget* parent = 0, SessionType type = Single, const char* name = 0);
        virtual ~Session();

        int id() { return session_id; }

        TQWidget* widget() { return base_widget; }

        int activeTerminalId();

        const TQString terminalIdList();

        const TQString title();
        const TQString title(int terminal_id);
        void setTitle(const TQString& title);
        void setTitle(int terminal_id, const TQString& title);

        void pasteClipboard();
        void pasteClipboard(int terminal_id);
        void pasteSelection();
        void pasteSelection(int terminal_id);

        void runCommand(const TQString& command);
        void runCommand(int terminal_id, const TQString& command);

        void removeTerminal();
        void removeTerminal(int terminal_id);


    public slots:
        void splitHorizontally();
        void splitHorizontally(int terminal_id);

        void splitVertically();
        void splitVertically(int terminal_id);

        void focusNextSplit();
        void focusPreviousSplit();

        void slotTitleChange(TQWidget* w, const TQString& title);


    signals:
        void destroyed(int id);
        void titleChanged(const TQString&);


    private:
        void createInitialSplits(SessionType);
        void split(TQWidget* active_terminal, Qt::Orientation o);
        Terminal* addTerminal(TQWidget* parent);
        bool checkFocusWidget();

        static int available_session_id;
        int session_id;
        TQString session_title;

        TQWidget* active_terminal;

        TerminalSplitter* base_widget;
        TerminalFocusWatcher* focus_watcher;

        TQMap<int, Terminal*> terminals;
        TQMap<TQWidget*, int> terminal_ids;
        TQMap<int, TQWidget*> terminal_widgets;
        TQMap<int, TerminalInterface*> terminal_parts;


    private slots: 
        void slotFocusChanged();
        void slotLastTerminalClosed();
        void cleanup(int terminal_id);
        void cleanup();
};

#endif /* SESSION_H */
