//////////////////////////////////////////////////////////////////////////
// plugin.cpp                                                           //
//                                                                      //
// Copyright (C)  2005  Lukas Tinkl <lukas@kde.org>                     //
//                                                                      //
// This program is free software; you can redistribute it and/or        //
// modify it under the terms of the GNU General Public License          //
// as published by the Free Software Foundation; either version 2       //
// of the License, or (at your option) any later version.               //
//                                                                      //
// This program is distributed in the hope that it will be useful,      //
// but WITHOUT ANY WARRANTY; without even the implied warranty of       //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
// GNU General Public License for more details.                         //
//                                                                      //
// You should have received a copy of the GNU General Public License    //
// along with this program; if not, write to the Free Software          //
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA            //
// 02110-1301, USA.                                                     //
//////////////////////////////////////////////////////////////////////////

#include "plugin.h"

#include <tqstring.h>

#include <kapplication.h>
#include <klocale.h>
#include <kglobal.h>

KonqSidebarDelicious::KonqSidebarDelicious( KInstance *instance, TQObject *parent,
                                            TQWidget *widgetParent, TQString &desktopName_,
                                            const char* name )
    : KonqSidebarPlugin( instance, parent, widgetParent, desktopName_, name ),
      DCOPObject( "sidebar-delicious" )

{
    m_widget = new MainWidget( instance->config(), widgetParent );
    connect( m_widget, TQT_SIGNAL( signalURLClicked( const KURL &, const KParts::URLArgs & ) ),
             this, TQT_SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ) );
    connect( m_widget, TQT_SIGNAL( signalURLMidClicked( const KURL &, const KParts::URLArgs & ) ),
             this, TQT_SIGNAL( createNewWindow( const KURL &, const KParts::URLArgs & ) ) );
}

KonqSidebarDelicious::~KonqSidebarDelicious()
{

}

void * KonqSidebarDelicious::provides( const TQString &  )
{
    return 0;
}

TQWidget * KonqSidebarDelicious::getWidget()
{
    return m_widget;
}

void KonqSidebarDelicious::handleURL( const KURL & url )
{
    m_widget->setCurrentURL( url );
}

bool KonqSidebarDelicious::universalMode()
{
    return true;
}

extern "C"
{
    KDE_EXPORT void* create_konqsidebar_delicious( KInstance *instance, TQObject *par, TQWidget *widp,
                                                   TQString &desktopname, const char *name )
    {
        KGlobal::locale()->insertCatalogue( "konqsidebar_delicious" );
        return new KonqSidebarDelicious( instance, par, widp, desktopname, name );
    }
}

extern "C"
{
   KDE_EXPORT bool add_konqsidebar_delicious( TQString* fn, TQString* /*param*/, TQMap<TQString,TQString> *map )
   {
       map->insert("Type", "Link");
       map->insert("Icon", "konqsidebar_delicious");
       map->insert("Name", i18n( "del.icio.us Bookmarks" ) );
       map->insert("Open", "false");
       map->insert("X-KDE-KonqSidebarModule", "konqsidebar_delicious");
       fn->setLatin1("delicious%1.desktop");
       return true;
   }
}

TQStringList KonqSidebarDelicious::tags() const
{
    return m_widget->tags();
}

TQStringList KonqSidebarDelicious::bookmarks() const
{
    return m_widget->bookmarks();
}

void KonqSidebarDelicious::newBookmark()
{
    m_widget->slotNewBookmark();
}

#include "plugin.moc"
