//
//
// C++ Interface dubplaylistitem.h
//
// Description: 
//
//
// Author: Eray Ozkural (exa), (C) 2001
//
// Copyright: See COPYING file that comes with this distribution
//
//


#ifndef DUBPLAYLISTITEM_H
#define DUBPLAYLISTITEM_H

#include <kfileitem.h>
#include <dubplaylistitem.h>

#include <noatun/playlist.h>

/**noatun playlistitem implementation
  *@author Eray Ozkural (exa)
  */

class KFileItem;

class DubPlaylistItem : public PlaylistItemData  {
public: 
  DubPlaylistItem(const KFileItem&);
  virtual ~DubPlaylistItem();

  virtual TQString property(const TQString &, const TQString & = 0) const;
  virtual void setProperty(const TQString &, const TQString &);
  virtual void clearProperty(const TQString &);
  virtual TQStringList properties() const;
  virtual bool isProperty(const TQString &) const;
  virtual KURL url() const;
  KFileItem& getFileItem() {
    return fileItem;
  }
  /** No descriptions */
  virtual void remove();

private:
  KFileItem fileItem;
  typedef TQMap<TQString,TQString> Properties;
  Properties property_map;

//	virtual TQString file() const;

};

#endif
