// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include <time.h>

#include <tqlabel.h>
#include <tqlayout.h>

#include <kapplication.h>

#include "File.h"
#include "TapeFileInfoWidget.h"
#include "Util.h"
#include <klocale.h>

#include "TapeFileInfoWidget.moc"

TapeFileInfoWidget::TapeFileInfoWidget( TQWidget* parent, const char* name )
        : TQWidget( parent, name )
{
    TQLabel* lbl1 = new TQLabel( i18n( "File name:" ), this );
    TQLabel* lbl2 = new TQLabel( i18n( "Last modified:" ), this );
    TQLabel* lbl3 = new TQLabel( i18n( "Size:" ), this );
    TQLabel* lbl4 = new TQLabel( i18n( "Start record:" ), this );
    TQLabel* lbl5 = new TQLabel( i18n( "End record:" ), this );

    int max = lbl1->tqsizeHint().width();
    if ( lbl2->tqsizeHint().width() > max ) max = lbl2->tqsizeHint().width();
    if ( lbl3->tqsizeHint().width() > max ) max = lbl3->tqsizeHint().width();
    if ( lbl4->tqsizeHint().width() > max ) max = lbl4->tqsizeHint().width();
    if ( lbl5->tqsizeHint().width() > max ) max = lbl5->tqsizeHint().width();

    lbl1->setFixedSize( max, lbl1->tqsizeHint().height() );
    lbl2->setFixedSize( max, lbl2->tqsizeHint().height() );
    lbl3->setFixedSize( max, lbl3->tqsizeHint().height() );
    lbl4->setFixedSize( max, lbl4->tqsizeHint().height() );
    lbl5->setFixedSize( max, lbl5->tqsizeHint().height() );

    _fileName = new TQLabel( "???", this );
    _fileName->setFixedHeight( _fileName->tqsizeHint().height() );

    _mtime = new TQLabel( "???", this );
    _mtime->setFixedHeight( _mtime->tqsizeHint().height() );

    _size = new TQLabel( "???", this );
    _size->setFixedHeight( _size->tqsizeHint().height() );

    _startRecord = new TQLabel( "???", this );
    _startRecord->setFixedHeight( _startRecord->tqsizeHint().height() );

    _endRecord = new TQLabel( "???", this );
    _endRecord->setFixedHeight( _endRecord->tqsizeHint().height() );

    TQVBoxLayout* l1 = new TQVBoxLayout( this, 4, 4 );

    TQHBoxLayout* l1_1 = new TQHBoxLayout();
    l1->addLayout( l1_1 );
    l1_1->addWidget( lbl1 );
    l1_1->addWidget( _fileName, 1 );

    TQHBoxLayout* l1_2 = new TQHBoxLayout();
    l1->addLayout( l1_2 );
    l1_2->addWidget( lbl2 );
    l1_2->addWidget( _mtime, 1 );

    TQHBoxLayout* l1_3 = new TQHBoxLayout();
    l1->addLayout( l1_3 );
    l1_3->addWidget( lbl3 );
    l1_3->addWidget( _size, 1 );

    TQHBoxLayout* l1_4 = new TQHBoxLayout();
    l1->addLayout( l1_4 );
    l1_4->addWidget( lbl4 );
    l1_4->addWidget( _startRecord, 1 );

    TQHBoxLayout* l1_5 = new TQHBoxLayout();
    l1->addLayout( l1_5 );
    l1_5->addWidget( lbl5 );
    l1_5->addWidget( _endRecord, 1 );

    l1->addStretch( 1 );
}

TapeFileInfoWidget::~TapeFileInfoWidget()
{
}

void TapeFileInfoWidget::setFile( File* file )
{
    _file = file;

    if ( !_file ) {
        return;
    }

    _fileName->setText( _file->getName() );

    TQString tmp;
    time_t tm = _file->getMTime();
    tmp = ctime( &tm );
    tmp = tmp.stripWhiteSpace();
    _mtime->setText( tmp );

    _startRecord->setText( Util::bytesToString( _file->getStartRecord() ) );

    _endRecord->setText( Util::bytesToString( _file->getEndRecord() ) );

    if ( _file->isDirectory() ) {
        TQPtrListIterator<Range> it( _file->getRanges() );
        int records = 0;
        for ( ; it.current(); ++it ) {
            records += it.current()->getEnd() - it.current()->getStart();
        }
        _size->setText( Util::kbytesToString( records / 2 ) );
    } else {
        _size->setText( Util::bytesToString( _file->getSize() ) );
    }
}
