/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/


#ifndef DEB_IFACE_H
#define DEB_IFACE_H

#include "../config.h"

#include <tqptrlist.h>
#include <tqdir.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqtextstream.h>
#include <tqstringlist.h>

#include <kprocess.h>

#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

#define AVAIL          "/var/lib/dpkg/available"
#define STATUS          "/var/lib/dpkg/status"

#define INFODIR         "/var/lib/dpkg/info/"


class DEB: public pkgInterface
{
  Q_OBJECT
  TQ_OBJECT

public:
  DEB();
  ~DEB();

  virtual bool isType(char *buf, const TQString &fname);

  virtual packageInfo *getPackageInfo(char mode, const TQString &name,
			      const TQString &version);
  virtual TQStringList getFileList(packageInfo *p);
  virtual TQStringList getChangeLog(packageInfo *p);

  bool filesTab(packageInfo *p);
  // If files tab is to be enabled

  bool changeTab(packageInfo *p);
  // If change log tab is to be enabled

  virtual void listInstalledPackages(TQPtrList<packageInfo> *pki);

  virtual TQStringList FindFile(const TQString &name, bool seachAll=false);
  virtual bool parseName(const TQString &name, TQString *n, TQString *v);

  virtual packageInfo* collectInfo(TQStringList &ln,  pkgInterface *pkgInt = 0);

  TQString uninstall(int uninstallFlags, TQPtrList<packageInfo> *p,
				  bool &test);
  TQString install(int installFlags, TQPtrList<packageInfo> *p,
				  bool &test);
  TQString doInstall(int installFlags, const TQString &packs, bool &test);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

protected:
  packageInfo *getIPackageInfo(const TQString &name);
  packageInfo *getIRPackageInfo(const TQString &name);
  packageInfo *getUPackageInfo(const TQString &name);

  TQStringList getIChangeLog(packageInfo *p);

  void listPackList(TQPtrList<packageInfo> *pki,
		    const TQString &fname, cacheObj *cp);

  virtual void distPackages(TQPtrList<packageInfo> *pki, cacheObj *cp);
  void listUnIPackages(TQPtrList<packageInfo> *pki, LcacheObj *pCache);

  TQStringList getIFileList(packageInfo *p);
  TQStringList getUFileList(const TQString &fn);
};

#endif



