/* EditWidget.cpp
**
** Copyright (C) 2000,2001 by Bernhard Rosenkraenzer
**
** Contributions by M. Laurent and W. Bastian.
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/
#include "EditWidget.moc"
#include "ui.h"
EditWidget::EditWidget(TQString const label, TQString const text, bool isFile, TQWidget *parent, const char *name, WFlags f, bool allowLines):TQHBox(allowLines, parent, name, f)
{
	setMargin(SPACE_MARGIN);
	setSpacing(SPACE_INSIDE);
	lbl=new TQLabel(label, this);
	setStretchFactor(lbl, 0);
	line=new TQLineEdit(text, this);
	setStretchFactor(line, 1);
	connect(line, TQT_SIGNAL(textChanged(const TQString &)), TQT_SIGNAL(textChanged(const TQString &)));
	connect(line, TQT_SIGNAL(returnPressed()), TQT_SIGNAL(returnPressed()));
	lbl->setBuddy(line);
	if(isFile) {
		select=new TQPushButton(_("Select..."), this);
		connect(select, TQT_SIGNAL(clicked()), TQT_SLOT(selectFileClicked()));
		select->resize(select->tqminimumSizeHint());
		setStretchFactor(select, 0);
	} else
		select=0;
}
void EditWidget::selectFileClicked()
{
    TQString filename=FileDlg::getOpenFileName(TQString(), TQString(), this);
    if(!filename.isEmpty())
	line->setText(filename);
}
TQSize EditWidget::tqsizeHint() const
{
	int w=2*SPACE_MARGIN+lbl->tqsizeHint().width()+SPACE_INSIDE+line->tqsizeHint().width();
	int h=lbl->tqsizeHint().height();
	if(h<line->tqsizeHint().height())
		h=line->tqsizeHint().height();
	if(select!=0) {
		w+=SPACE_INSIDE+select->tqsizeHint().width();
		if(h<select->tqsizeHint().height())
			h=select->tqsizeHint().height();
	}
	return TQSize(w, h);
}
TQSize EditWidget::tqminimumSizeHint() const
{
	int w=2*SPACE_MARGIN+lbl->tqminimumSizeHint().width()+SPACE_INSIDE+line->tqminimumSizeHint().width();
	int h=lbl->tqminimumSizeHint().height();
	if(h<line->tqminimumSizeHint().height())
		h=line->tqminimumSizeHint().height();
	if(select!=0) {
		w+=SPACE_INSIDE+select->tqminimumSizeHint().width();
		if(h<select->tqminimumSizeHint().height())
			h=select->tqminimumSizeHint().height();
	}
	return TQSize(w, h);
}
