// -*- c++ -*-

/*
 *  Copyright (C) 2004, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */
#include "ksimpleprocess.h"
#include <tqapplication.h>
#include <klocale.h>
static TQStringList  splitArgList( const TQString &args)
{
	TQStringList returnArgs = TQStringList::split( ' ', args);
	return returnArgs;
}

TQString KSimpleProcess::exec( const TQString &args, bool addStdErr )
{
	KSimpleProcess proc;
	return proc.execInternal( args, addStdErr);
}

TQString KSimpleProcess::execInternal( const TQString &args, bool addStdError)
{
	m_proc->setArguments( splitArgList( args ));
	connect(m_proc, TQT_SIGNAL(processExited()), this, TQT_SLOT(slotProcessExited()));
	connect(m_proc, TQT_SIGNAL(readyReadStdout()), this, TQT_SLOT(slotReceivedStdout()));
	if( addStdError )
		connect(m_proc, TQT_SIGNAL(readyReadStderr()), this, TQT_SLOT(slotReceivedStderr()));

	if ( !m_proc->start()  )
		return i18n("Could not run command '%1'.").arg( args.latin1() );
	enter_loop();
	return m_currBuffer;
}

KSimpleProcess::KSimpleProcess() : TQObject(0,0)
{
	m_currBuffer = "";
	m_stdErrOn = false;
	m_proc = new TQProcess(this);
}

KSimpleProcess::~KSimpleProcess()
{
	delete m_proc;
}


// If a troll sees this, he kills david not me
void qt_enter_modal( TQWidget *widget );
void qt_leave_modal( TQWidget *widget );

void KSimpleProcess::enter_loop()
{
  TQWidget dummy(0,0,WType_Dialog | WShowModal);
  dummy.setFocusPolicy( TQWidget::NoFocus );
  qt_enter_modal(&dummy);
  qApp->enter_loop();
  qt_leave_modal(&dummy);
}

void KSimpleProcess::slotProcessExited()
{
	while( m_proc->canReadLineStdout() )
		m_currBuffer += m_proc->readLineStdout() + '\n';
	qApp->exit_loop();
}

void KSimpleProcess::slotReceivedStdout()
{
	m_currBuffer += m_proc->readLineStdout() + '\n';
}

void KSimpleProcess::slotReceivedStderr()
{
	m_currBuffer += m_proc->readLineStderr() + '\n';
}

#include "ksimpleprocess.moc"
