


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvasitemlist_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasItemListImp::QCanvasItemListImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasItemListImp::~QCanvasItemListImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasItemListImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasItemListImp *meth = new QCanvasItemListImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasItemListImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_sort_1, "sort" },
        { Method_drawUnique_2, "drawUnique" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasItemListImp *meth = new QCanvasItemListImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvasItemList pointer from an Object.
 */
TQCanvasItemList *QCanvasItemListImp::toQCanvasItemList( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvasItemList *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQCanvasItemList" )
        return 0;

    return op->toNative<TQCanvasItemList>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasItemListImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         default:
             break;
    }

    TQString msg = i18n("QCanvasItemListCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value QCanvasItemListImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasItemListImp::toQCanvasItemList( self );

    switch( id ) {

    case Method_sort_1:
        return sort_1( exec, self, args );
        break;

    case Method_drawUnique_2:
        return drawUnique_2( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "QCanvasItemListImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value QCanvasItemListImp::sort_1( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->sort(  );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasItemListImp::drawUnique_2( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPainter arg0; // TODO (hack for qcanvas)

      instance->drawUnique(
       arg0 );
      return KJS::Value(); // Returns void

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


