
  

#ifndef KJSEMBED_QCanvasPixmapArray_H
#define KJSEMBED_QCanvasPixmapArray_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class TQCanvasPixmapArray;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for TQCanvasPixmapArray methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class QCanvasPixmapArrayImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasPixmapArray_1,
       Constructor_QCanvasPixmapArray_2,
       Constructor_QCanvasPixmapArray_3,
       Constructor_QCanvasPixmapArray_4,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_readPixmaps_6,
       Method_readCollisionMasks_7,
       Method_isValid_9,
       Method_image_10,
       Method_setImage_11,
       Method_count_12,
       Method_Last = -1
   };

   QCanvasPixmapArrayImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~QCanvasPixmapArrayImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static TQCanvasPixmapArray *toQCanvasPixmapArray( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object QCanvasPixmapArray_1( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object QCanvasPixmapArray_2( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object QCanvasPixmapArray_3( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object QCanvasPixmapArray_4( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value readPixmaps_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value readCollisionMasks_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value isValid_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value image_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setImage_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value count_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   TQCanvasPixmapArray *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasPixmapArray_H

// Local Variables:
// c-basic-offset: 4
// End:


