// Copyright (C)  2002  Dominique Devriese <devriese@kde.org>

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#ifndef KIG_MISC_GUIACTION_H
#define KIG_MISC_GUIACTION_H

#include <config.h>

#ifdef KIG_ENABLE_PYTHON_SCRIPTING
#include "../scripting/script-common.h"
#endif

#include <tqstring.h>
#include <tqcstring.h>
#include <kaction.h>

class GUIAction;
class KigPart;

class KigGUIAction
  : public KAction
{
  Q_OBJECT
  TQ_OBJECT
  GUIAction* mact;
  KigPart& mdoc;
public:
  KigGUIAction( GUIAction* act,
                KigPart& doc,
                TQObject* parent );
  void slotActivated();

  GUIAction* guiAction();

  void plug( KigPart* doc );
};

class GUIAction
{
public:
  virtual ~GUIAction();

  virtual TQString description() const = 0;
  virtual TQCString iconFileName() const = 0;
  virtual TQString descriptiveName() const = 0;
  virtual const char* actionName() const = 0;
  virtual int shortcut() const = 0;
  virtual void act( KigPart& ) = 0;

  virtual void plug( KigPart* doc, KigGUIAction* kact );
};

class ObjectConstructor;

class ConstructibleAction
  : public GUIAction
{
  ObjectConstructor* mctor;
  TQCString mactionname;
  int mshortcut;
public:
  ConstructibleAction( ObjectConstructor* ctor, const TQCString& actionname,
                       int shortcut = 0 );
  ~ConstructibleAction();
  TQString description() const;
  TQCString iconFileName() const;
  TQString descriptiveName() const;
  const char* actionName() const;
  int shortcut() const;
  void act( KigPart& );
  void plug( KigPart* doc, KigGUIAction* kact );
};

class ConstructPointAction
  : public GUIAction
{
  const char* mactionname;
public:
  ConstructPointAction( const char* actionname );
  ~ConstructPointAction();

  TQString description() const;
  TQCString iconFileName() const;
  TQString descriptiveName() const;
  const char* actionName() const;
  int shortcut() const;
  void act( KigPart& );
};

class ConstructTextLabelAction
  : public GUIAction
{
  const char* mactionname;
public:
  ConstructTextLabelAction( const char* actionname );

  TQString description() const;
  TQCString iconFileName() const;
  TQString descriptiveName() const;
  const char* actionName() const;
  int shortcut() const;
  void act( KigPart& );
};

class AddFixedPointAction
  : public GUIAction
{
  const char* mactionname;
public:
  AddFixedPointAction( const char* actionname );
  ~AddFixedPointAction();
  TQString description() const;
  TQCString iconFileName() const;
  TQString descriptiveName() const;
  const char* actionName() const;
  int shortcut() const;
  void act( KigPart& );
};

#if 0
class TestAction
  : public GUIAction
{
  const char* mactionname;
public:
  TestAction( const char* actionname );
  ~TestAction();
  TQString description() const;
  TQCString iconFileName() const;
  TQString descriptiveName() const;
  const char* actionName() const;
  void act( KigPart& );
};
#endif

#ifdef KIG_ENABLE_PYTHON_SCRIPTING

class NewScriptAction
  : public GUIAction
{
  const char* mactionname;
  const char* mdescname;
  const char* mdescription;
  const char* micon;
  const ScriptType::Type mtype;
public:
  NewScriptAction( const char* descname, const char* description,
                   const char* actionname, const ScriptType::Type type,
                   const char* icon = "" );
  ~NewScriptAction();
  TQString description() const;
  TQCString iconFileName() const;
  TQString descriptiveName() const;
  const char* actionName() const;
  void act( KigPart& );
  int shortcut() const;
};

#endif // KIG_ENABLE_PYTHON_SCRIPTING

#endif
