/***************************************************************************

                   enter document title and author

    -----------------------------------------------------------------------

    begin          : Thu Mar 11 20:50:53 MET 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "TitlePage.h"


#include <kapplication.h>
#include <klocale.h>

#include <tqlineedit.h>
#include <tqmultilineedit.h>
#include <tqlabel.h>

TitlePage::TitlePage
(
  TQString  _title,
  TQString  _author,
  TQString  _license,
  TQString  _doc_remark,
  TQWidget* parent,
  const char* name
)
  :
  TitlePageForm( parent, name )
{
  title = _title;
  author = _author;
  license = _license;
  doc_remark = _doc_remark;

  e_author->setText (author);
  label_author->setBuddy(e_author);

  e_title->setText (title);
  e_title->setFocus();
  e_title->selectAll();
  label_title->setBuddy(e_title);

  e_license->setText (license);
  label_license->setBuddy(e_license);

  e_remark->setText (doc_remark);
  label_remark->setBuddy(e_remark);

  connect( e_author, TQT_SIGNAL(textChanged()),  TQT_SLOT(slotAuthorChanged()) );
  connect( e_title, TQT_SIGNAL(textChanged(const TQString&)),   TQT_SLOT(slotTitleChanged(const TQString&)) );
  connect( e_license, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(slotLicenseChanged(const TQString&)) );
  connect( e_remark, TQT_SIGNAL(textChanged()),  TQT_SLOT(slotDocRemarkChanged()) );
}


void TitlePage::slotTitleChanged(const TQString& s)
{
  title = s;
}


void TitlePage::slotAuthorChanged()
{
  author = e_author->text();
}


void TitlePage::slotLicenseChanged(const TQString& s)
{
  license = s;
}


void TitlePage::slotDocRemarkChanged()
{
  doc_remark = e_remark->text();
}

#include "TitlePage.moc"
