/* Class Ball, BallWidget
 *
 * Online rendered balls with caching + animation widget
 *
 * Supported static effects
 *  - ball color
 *  - ripple texture
 *
 * Supported animation sequences for now:
 *  - Color Blending
 *  - Texture rotate
 *
 * April 1999, Josef Weidendorfer
 */

#ifndef _BALL_H_
#define _BALL_H_

#include <tqpixmap.h>
#include <tqimage.h>
#include <tqcolor.h>
#include <tqwidget.h>
#include <tqptrlist.h>

/* textures for balls */
#define TEX_FLAT   0
#define TEX_RIPPLE 1

class Ball {
  
 public:
  Ball(const TQColor& c, double a = 0.0, int t=TEX_RIPPLE );
  ~Ball();

  TQPixmap* pixmap();

  double angle() { return an; }
  TQColor ballColor() { return bColor; }
  void setSpecials(double z, double f, double l)
    { zoom = z, flip=f, limit=l; }

  static int w() { return sizeX; }
  static int h() { return sizeY; }
  static void setSize(int x,int y);
  static void setLight(int x=5, int y=3, int z=10, 
		       const TQColor& c = TQColor(200,230,255) );
  static void setTexture(double c=13., double d=.2);

 private:

  void render();
  static void tqinvalidate();

  //static TQImage back;
  static int sizeX, sizeY;
  static double lightX, lightY, lightZ;
  static TQColor lightColor;
  static double rippleCount, rippleDepth;

  TQPixmap pm;
  TQColor bColor;
  double an, sina, cosa;
  double zoom, flip, limit;
  int tex;

  Ball *next;
  static Ball* first;
};


class BallAnimation {
 public:
  BallAnimation(int s, Ball*, Ball*);

  int steps;
  TQPtrList<Ball> balls;
};

#define ANIMATION_STOPPED 0
#define ANIMATION_FORWARD 1
#define ANIMATION_BACK    2
#define ANIMATION_LOOP    3
#define ANIMATION_CYCLE   4

class BallPosition {
 public:
  BallPosition(int xp,int yp, Ball* d);

  int x, y, actStep, actDir, actType;
  Ball* def;
  BallAnimation* actAnimation;
};

#define MAX_POSITION  130
#define MAX_ANIMATION  20

class BallWidget : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT

 public:
  BallWidget(int _freq, int bFr, TQWidget *parent = 0, const char *name = 0);
  ~BallWidget();

  void createBlending(int, int, Ball* , Ball* );
  void createBallPosition(int, int x, int y, Ball*);
  
  void startAnimation(int pos, int anim, int type=ANIMATION_FORWARD);
  void stopAnimation(int pos);

  void paint(TQPaintDevice *);
  
  virtual void resizeEvent(TQResizeEvent *);
  virtual void paintEvent(TQPaintEvent *);

 signals:
  void animationFinished(int);
  void animationsFinished(void);

 protected:
  void drawBackground();

 private slots:
  void animate();

 protected:
  TQMemArray<BallPosition*> positions;
  TQMemArray<BallAnimation*> animations;

 private:
  int freq;
  int xStart, yStart, realSize, ballFraction;
  bool isRunning;
  TQTimer *timer;
};


/* Ball Test */

class BallTest: public BallWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  BallTest(TQWidget *parent=0, const char *name=0 );
protected:
  void mousePressEvent( TQMouseEvent * );
  void mouseReleaseEvent( TQMouseEvent * );


};




#endif // _BALL_H_  
