
#ifndef HighScore_included
#define HighScore_included

#include <tqdialog.h>


class TQLineEdit;
class TQComboBox;
class TQLabel;

const int numScores = 10;

typedef struct HiScoreEntry  {
	TQString name;
	long	board;
	long 	score;
	long elapsed;
	
};

typedef struct TableInstance  {
	TQString name;
	HiScoreEntry entries[numScores];
	TableInstance *next;	
};


class HighScore : public TQDialog
{
    Q_OBJECT
  TQ_OBJECT

public:

    HighScore
    (
        TQWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~HighScore();

	int exec(TQString &tqlayout);


    void checkHighScore(int score, int elapsed, long game, TQString &board);
public slots:
	void selectionChanged(int);

protected slots:
	void nameChanged(const TQString &s);
	void reset();
private:
	void 		addRow(int num);	// generate one table row 
	void		loadTables();	// initialise from saved
	void		saveTables();	// save to disc.
	void		getBoardName(TQString in, TQString &out);
	void 		selectTable(const TQString &name);
	void		setComboTo(const TQString &to);
	void		copyTableToScreen(const TQString &name);
	TQString		&highScoreFile();
	
	int 		selectedLine;
	TQLineEdit   	*lineEdit;
        TQLabel*		numbersWidgets[numScores];
	TQLabel* 	boardWidgets[numScores];
        TQLabel*     	namesWidgets[numScores];
        TQLabel* 	scoresWidgets[numScores]; 
	TQLabel*       elapsedWidgets[numScores]; 
	TQComboBox*	combo;
	TQString 	filename;

	TableInstance *tables;		
	TableInstance *currTable;		
};

#endif // HighScore_included
