#include <tqlabel.h>
#include <tqlayout.h>

#include <kdialog.h>
#include <klocale.h>

#include "config.h"

Config::Config(TQWidget *parent, const char *name)
	: TQFrame(parent, name)
{
	startedUp = false;
}

void Config::ctorDone()
{
	startedUp = true;
}

int Config::spacingHint()
{
	return KDialog::spacingHint() / 2;
}

int Config::marginHint()
{
	return KDialog::marginHint();
}

void Config::changed()
{
	if (startedUp)
		emit modified();
}

MessageConfig::MessageConfig(TQString text, TQWidget *parent, const char *name)
	: Config(parent, name)
{
	TQVBoxLayout *tqlayout = new TQVBoxLayout(this, marginHint(), spacingHint());
	tqlayout->addWidget(new TQLabel(text, this));
}

DefaultConfig::DefaultConfig(TQWidget *parent, const char *name)
	: MessageConfig(i18n("No configuration options"), parent, name)
{
}

#include "config.moc"
