#include <tqbrush.h>
#include <tqcolor.h>
#include <tqcanvas.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>

#include <klocale.h>
#include <klibloader.h>
#include <kapplication.h>
#include <kdebug.h>
#include <knuminput.h>
#include <kconfig.h>

#include <kolf/statedb.h>
#include <kolf/canvasitem.h>
#include "poolball.h"

K_EXPORT_COMPONENT_FACTORY(libkolfpoolball, PoolBallFactory)
TQObject *PoolBallFactory::createObject (TQObject *, const char *, const char *, const TQStringList &) { return new PoolBallObj; }

PoolBall::PoolBall(TQCanvas *canvas)
	: Ball(canvas)
{
	setBrush(black);
	m_number = 1;
}

void PoolBall::save(KConfig *cfg)
{
	cfg->writeEntry("number", number());
}

void PoolBall::saveState(StateDB *db)
{
	db->setPoint(TQPoint(x(), y()));
}

void PoolBall::load(KConfig *cfg)
{
	setNumber(cfg->readNumEntry("number", 1));
}

void PoolBall::loadState(StateDB *db)
{
	move(db->point().x(), db->point().y());
	setVelocity(0, 0);
	setState(Stopped);
}

void PoolBall::draw(TQPainter &p)
{
	// we should draw the number here
	Ball::draw(p);
}

PoolBallConfig::PoolBallConfig(PoolBall *poolBall, TQWidget *parent)
	: Config(parent), m_poolBall(poolBall)
{
	TQVBoxLayout *tqlayout = new TQVBoxLayout(this, marginHint(), spacingHint());

	tqlayout->addStretch();

	TQLabel *num = new TQLabel(i18n("Number:"), this);
	tqlayout->addWidget(num);
	KIntNumInput *slider = new KIntNumInput(m_poolBall->number(), this);
	slider->setRange(1, 15);
	tqlayout->addWidget(slider);

	tqlayout->addStretch();

	connect(slider, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(numberChanged(int)));
}

void PoolBallConfig::numberChanged(int newNumber)
{
	m_poolBall->setNumber(newNumber);
	changed();
}

Config *PoolBall::config(TQWidget *parent)
{
	return new PoolBallConfig(this, parent);
}

#include "poolball.moc"
