#include <tqlabel.h>
#include <tqlayout.h>
#include <tqslider.h>
#include <tqvbox.h>

#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>
#include <kstdguiitem.h>

#include "gameenddlg.h"
#include "gameenddlg.moc"

GameEndDlg::GameEndDlg( TQWidget *parent )
    : KDialogBase( i18n("Out of Turns"), 
      KDialogBase::Yes|KDialogBase::No, KDialogBase::Yes, KDialogBase::No,
      parent, "end_game_dialog", true, true )
{
    TQVBox *page = makeVBoxMainWidget();

    // Create controls
    TQLabel *label1 = new TQLabel( i18n("This is the last turn.\nDo you wish to add extra turns?")+"\n\n", page );
    label1->tqsetAlignment( AlignCenter );
    
    turnCountLbl = new TQLabel( page );
    turnCount = new TQSlider( 1, 40, 1, 5, Qt::Horizontal, page );

    KGuiItem addTurns(i18n("&Add Turns"), TQString(), TQString(),
                      i18n("Add the specified number of turns to the game and continue playing."));
    KGuiItem gameOver(i18n("&Game Over"), TQString(), TQString(),
                      i18n("Terminate the current game."));
    
    setButtonGuiItem(KDialogBase::Yes, addTurns);
    setButtonGuiItem(KDialogBase::No, gameOver);

    init();

    connect( turnCount, TQT_SIGNAL(valueChanged( int )), this, TQT_SLOT(turnCountChange( int )) );
}

GameEndDlg::~GameEndDlg()
{
}

void
GameEndDlg::init()
{
    KConfig *config = kapp->config();
    config->setGroup("Game");
    int turns = config->readNumEntry("ExtraTurns", 10);
    turnCount->setValue(turns);
    turnCountChange(turns);
}

void
GameEndDlg::slotYes()
{
    KConfig *config = kapp->config();
    config->setGroup("Game");
    config->writeEntry("ExtraTurns", extraTurns());
    config->sync();
    KDialogBase::slotYes();
}

int
GameEndDlg::extraTurns()
{
    return turnCount->value();
}

void
GameEndDlg::turnCountChange( int newTurnCount )
{
    TQString newLbl = i18n("Extra turns: %1").tqarg( newTurnCount );
    turnCountLbl->setText( newLbl);
}
