/*
 *  ksokoban - a Sokoban game for KDE
 *  Copyright (C) 1998  Anders Widell  <d95-awi@nada.kth.se>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef IMAGEDATA_H
#define IMAGEDATA_H

#include <tqimage.h>
#include <tqpixmap.h>
#include <tqcstring.h>

#include <krandomsequence.h>

class TQPainter;

#define SMALL_STONES 4
#define LARGE_STONES 6
#define OTHER_IMAGES 5
#define NO_OF_IMAGES (SMALL_STONES + LARGE_STONES + OTHER_IMAGES)

class
ImageData {
public:
  virtual ~ImageData();

  int resize(int size);
  int size() { return size_; }

  void wall(TQPainter &p, int x, int y, int index, bool left, bool right);
  void floor(TQPainter &p, int x, int y);
  void goal(TQPainter &p, int x, int y);
  void man(TQPainter &p, int x, int y);
  void object(TQPainter &p, int x, int y);
  void saveman(TQPainter &p, int x, int y);
  void treasure(TQPainter &p, int x, int y);
  void brightObject(TQPainter &p, int x, int y);
  void brightTreasure(TQPainter &p, int x, int y);

  const TQPixmap &background() { return background_; }
  const TQImage& objectImg() const { return objectImg_; }

protected:
  ImageData();

  void expandIndex(int size);
  void image2pixmap(TQImage img, TQPixmap& xpm, bool diffuse=true);
  void brighten(TQImage& img);

  const TQPixmap &upperLarge(int index);
  const TQPixmap &lowerLarge(int index);
  const TQPixmap &leftSmall(int index);
  const TQPixmap &rightSmall(int index);

  TQImage images_[NO_OF_IMAGES];

  TQPixmap smallStone_xpm_[SMALL_STONES];
  TQPixmap largeStone_xpm_[LARGE_STONES];
  TQPixmap otherPixmaps_[OTHER_IMAGES];
  TQPixmap background_, brightObject_, brightTreasure_;
  TQImage  objectImg_;
  
  int indexSize_;
  TQByteArray upperLargeIndex_;
  TQByteArray lowerLargeIndex_;
  TQByteArray leftSmallIndex_;
  TQByteArray rightSmallIndex_;

  int size_, halfSize_;
  KRandomSequence random;
};

#endif  /* IMAGEDATA_H */
