/*
    This file is part of the KDE games library
    Copyright (C) 2001 Andreas Beckermann (b_mann@gmx.de)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "kchatdialog.h"

#include "kchatbase.h"

#include <klocale.h>
#include <kfontdialog.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpushbutton.h>

class KChatDialogPrivate
{
 public:
	KChatDialogPrivate()
	{
		mTextPage = 0;

		mNamePreview = 0;
		mTextPreview = 0;
		mSystemNamePreview = 0;
		mSystemTextPreview = 0;

		mChat = 0;
	}

	TQFrame* mTextPage;

	TQLabel* mNamePreview;
	TQLabel* mTextPreview;
	TQLabel* mSystemNamePreview;
	TQLabel* mSystemTextPreview;

	TQLineEdit* mMaxMessages;

	KChatBase* mChat;
};

KChatDialog::KChatDialog(KChatBase* chat, TQWidget* parent, bool modal) 
//	: KDialogBase(Tabbed, i18n("Configure Chat"), Ok|Default|Apply|Cancel, Ok, parent, 0, modal, true)
	: KDialogBase(Plain, i18n("Configure Chat"), Ok|Default|Apply|Cancel, Ok, parent, 0, modal, true)
{
 init();
 plugChatWidget(chat);
}

KChatDialog::KChatDialog(TQWidget* parent, bool modal) 
//	: KDialogBase(Tabbed, i18n("Configure Chat"), Ok|Default|Apply|Cancel, Ok, parent, 0, modal, true)
	: KDialogBase(Plain, i18n("Configure Chat"), Ok|Default|Apply|Cancel, Ok, parent, 0, modal, true)
{
 init();
}

KChatDialog::~KChatDialog()
{
 delete d;
}

void KChatDialog::init()
{
 d = new KChatDialogPrivate;
// d->mTextPage = addPage(i18n("&Messages"));// not a good name - game Messages?
 d->mTextPage = plainPage();
 TQGridLayout* tqlayout = new TQGridLayout(d->mTextPage, 7, 2, KDialog::marginHint(), KDialog::spacingHint());

// General fonts
 TQPushButton* nameFont = new TQPushButton(i18n("Name Font..."), d->mTextPage);
 connect(nameFont, TQT_SIGNAL(pressed()), this, TQT_SLOT(slotGetNameFont()));
 tqlayout->addWidget(nameFont, 0, 0);
 TQPushButton* textFont = new TQPushButton(i18n("Text Font..."), d->mTextPage);
 connect(textFont, TQT_SIGNAL(pressed()), this, TQT_SLOT(slotGetTextFont()));
 tqlayout->addWidget(textFont, 0, 1);

 TQFrame* messagePreview = new TQFrame(d->mTextPage);
 messagePreview->setFrameStyle(TQFrame::StyledPanel | TQFrame::Sunken);
 TQHBoxLayout* messageLayout = new TQHBoxLayout(messagePreview);
 tqlayout->addMultiCellWidget(messagePreview, 1, 1, 0, 1);

 d->mNamePreview = new TQLabel(i18n("Player: "), messagePreview);
 messageLayout->addWidget(d->mNamePreview, 0);
 d->mTextPreview = new TQLabel(i18n("This is a player message"), messagePreview);
 messageLayout->addWidget(d->mTextPreview, 1);

 tqlayout->addRowSpacing(2, 10);
 
// System Message fonts
 TQLabel* systemMessages = new TQLabel(i18n("System Messages - Messages directly sent from the game"), d->mTextPage);
 tqlayout->addMultiCellWidget(systemMessages, 3, 3, 0, 1);
 TQPushButton* systemNameFont = new TQPushButton(i18n("Name Font..."), d->mTextPage);
 connect(systemNameFont, TQT_SIGNAL(pressed()), this, TQT_SLOT(slotGetSystemNameFont()));
 tqlayout->addWidget(systemNameFont, 4, 0);
 TQPushButton* systemTextFont = new TQPushButton(i18n("Text Font..."), d->mTextPage);
 connect(systemTextFont, TQT_SIGNAL(pressed()), this, TQT_SLOT(slotGetSystemTextFont()));
 tqlayout->addWidget(systemTextFont, 4, 1);

 TQFrame* systemMessagePreview = new TQFrame(d->mTextPage);
 systemMessagePreview->setFrameStyle(TQFrame::StyledPanel | TQFrame::Sunken);
 TQHBoxLayout* systemMessageLayout = new TQHBoxLayout(systemMessagePreview);
 tqlayout->addMultiCellWidget(systemMessagePreview, 5, 5, 0, 1);
 
 d->mSystemNamePreview = new TQLabel(i18n("--- Game: "), systemMessagePreview);
 systemMessageLayout->addWidget(d->mSystemNamePreview, 0);
 d->mSystemTextPreview = new TQLabel(i18n("This is a system message"), systemMessagePreview);
 systemMessageLayout->addWidget(d->mSystemTextPreview, 1);

// message count
 TQLabel* maxMessages = new TQLabel(i18n("Maximal number of messages (-1 = unlimited):"), d->mTextPage);
 tqlayout->addWidget(maxMessages, 6, 0);
 d->mMaxMessages = new TQLineEdit(d->mTextPage);
 d->mMaxMessages->setText(TQString::number(-1));
 tqlayout->addWidget(d->mMaxMessages, 6, 1);
}

void KChatDialog::slotGetNameFont()
{
 TQFont font = nameFont();
 KFontDialog::getFont(font);
 setNameFont(font);
}

void KChatDialog::slotGetTextFont()
{
 TQFont font = textFont();
 KFontDialog::getFont(font);
 setTextFont(font);
}

void KChatDialog::slotGetSystemNameFont()
{
 TQFont font = systemNameFont();
 KFontDialog::getFont(font);
 setSystemNameFont(font);
}

void KChatDialog::slotGetSystemTextFont()
{
 TQFont font = systemTextFont();
 KFontDialog::getFont(font);
 setSystemTextFont(font);
}

TQFont KChatDialog::nameFont() const
{
 return d->mNamePreview->font();
}

TQFont KChatDialog::textFont() const
{
 return d->mTextPreview->font();
}

TQFont KChatDialog::systemNameFont() const
{
 return d->mSystemNamePreview->font();
}

TQFont KChatDialog::systemTextFont() const
{
 return d->mSystemTextPreview->font();
}

void KChatDialog::plugChatWidget(KChatBase* widget, bool applyFonts)
{
 d->mChat = widget;
 if (applyFonts && d->mChat) {
	setNameFont(d->mChat->nameFont());
	setTextFont(d->mChat->messageFont());
	setSystemNameFont(d->mChat->systemNameFont());
	setSystemTextFont(d->mChat->systemMessageFont());
	setMaxMessages(d->mChat->maxItems());
 }
}

void KChatDialog::configureChatWidget(KChatBase* widget)
{
 if (!widget) {
	return;
 }
 widget->setNameFont(nameFont());
 widget->setMessageFont(textFont());

 widget->setSystemNameFont(systemNameFont());
 widget->setSystemMessageFont(systemTextFont());
 
 widget->setMaxItems(maxMessages());
}

void KChatDialog::slotOk()
{
 slotApply();
 KDialogBase::slotOk();
}

void KChatDialog::slotApply()
{
 configureChatWidget(d->mChat);
}

void KChatDialog::setNameFont(TQFont f)
{
 d->mNamePreview->setFont(f);
}

void KChatDialog::setTextFont(TQFont f)
{
 d->mTextPreview->setFont(f);
}

void KChatDialog::setSystemNameFont(TQFont f)
{
 d->mSystemNamePreview->setFont(f);
}

void KChatDialog::setSystemTextFont(TQFont f)
{
 d->mSystemTextPreview->setFont(f);
}

void KChatDialog::setMaxMessages(int max)
{
 d->mMaxMessages->setText(TQString::number(max));
}

int KChatDialog::maxMessages() const
{
 bool ok;
 int max = d->mMaxMessages->text().toInt(&ok);
 if (!ok) {
	return -1; // unlimited is default
 }
 return max;
}

#include "kchatdialog.moc"
