#ifndef MP_SIMPLE_BOARD_H
#define MP_SIMPLE_BOARD_H

#include "mp_board.h"
#include "mp_simple_types.h"

#include <kdemacros.h>

class KDE_EXPORT MPSimpleBoard : public MPBoard
{
 Q_OBJECT
  TQ_OBJECT
		
 public:
    MPSimpleBoard(TQWidget *parent = 0, const char *name = 0)
	: MPBoard(parent, name) {}
	virtual ~MPSimpleBoard() {}

	void init(bool AI, bool multiplayers, bool server, bool first,
			  const TQString &name);
	void dataOut(TQDataStream &s);
	void dataIn(TQDataStream &s);
	
 protected:
	virtual void _init(bool AI, bool multiplayers, bool server, bool first,
					   const TQString &name) = 0;
	virtual void _initFlag(TQDataStream &s) = 0;
	virtual void _playFlag(TQDataStream &s) = 0;
	virtual void _pauseFlag(bool pause)    = 0;
	virtual void _stopFlag(bool gameover)  = 0;
	virtual void _dataOut(TQDataStream &s)  = 0;
	virtual void _gameOverDataOut(TQDataStream &s) = 0;
	virtual void _initDataOut(TQDataStream &s) = 0;

 private:
	BoardState state;
	
	void initFlag(TQDataStream &s);
	void playFlag(TQDataStream &s);
	void pauseFlag();
	void stopFlag();
	void gameOverFlag();
	void _stop(bool button);
};

#endif // MP_SIMPLE_BOARD_H
