
/*
   Copyright (c) 2003,2004,2005 Clarence Dang <dang@kde.org>
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
   IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
   IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
   NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#ifndef __kp_color_toolbar_h__
#define __kp_color_toolbar_h__


#include <tqframe.h>
#include <tqwidget.h>

#include <kcolordialog.h>
#include <ktoolbar.h>

#include <kpcolor.h>
#include <kpcolorsimilaritycube.h>


class TQGridLayout;
class KColorButton;

class kpColorSimilarityCube;
class kpMainWindow;


//
// Widget similar to KDualColorButton.
// Main differences:
// - more consistent feel with other KolourPaint widgets
//   (esp. kpColorPalette)
// - displays the transparent colour using the special pixmap
//   used by kpTransparentColorCell
// - no obscure "current" colour
//
class kpDualColorButton : public TQFrame
{
Q_OBJECT
  TQ_OBJECT

public:
    kpDualColorButton (kpMainWindow *mainWindow,
                       TQWidget *parent, const char *name = 0);
    virtual ~kpDualColorButton ();

    kpColor color (int which) const;
    kpColor foregroundColor () const;
    kpColor backgroundColor () const;

public slots:
    void setColor (int which, const kpColor &color);
    void setForegroundColor (const kpColor &color);
    void setBackgroundColor (const kpColor &color);

signals:
    // If you connect to this signal, ignore the following
    // foregroundColorChanged() and backgroundColorChanged() signals
    void colorsSwapped (const kpColor &newForegroundColor,
                        const kpColor &newBackgroundColor);

    void foregroundColorChanged (const kpColor &color);
    void backgroundColorChanged (const kpColor &color);

public:
    // (only valid in slots connected to foregroundColorChanged())
    kpColor oldForegroundColor () const;
    // (only valid in slots connected to backgroundColorChanged())
    kpColor oldBackgroundColor () const;

public:
    virtual TQSize tqsizeHint () const;

protected:
    TQRect swapPixmapRect () const;
    TQRect foregroundBackgroundRect () const;
    TQRect foregroundRect () const;
    TQRect backgroundRect () const;

    //virtual void dragEnterEvent (TQDragEnterEvent *e);
    virtual void dragMoveEvent (TQDragMoveEvent *e);
    virtual void dropEvent (TQDropEvent *e);

    virtual void mousePressEvent (TQMouseEvent *e);
    virtual void mouseDoubleClickEvent (TQMouseEvent *e);
    virtual void mouseReleaseEvent (TQMouseEvent *e);

    virtual void drawContents (TQPainter *p);

    kpMainWindow *m_mainWindow;
    kpColor m_color [2];
    kpColor m_oldColor [2];
    TQPixmap *m_backBuffer;
};


class kpColorCells : public KColorCells
{
Q_OBJECT
  TQ_OBJECT

public:
    kpColorCells (TQWidget *parent,
                  Qt::Orientation o = Qt::Horizontal,
                  const char *name = 0);
    virtual ~kpColorCells ();

    Qt::Orientation orientation () const;
    void setOrientation (Qt::Orientation o);

signals:
    void foregroundColorChanged (const TQColor &color);
    void backgroundColorChanged (const TQColor &color);

    // lazy
    void foregroundColorChanged (const kpColor &color);
    void backgroundColorChanged (const kpColor &color);

protected:
    Qt::Orientation m_orientation;

    virtual void dropEvent (TQDropEvent *e);
    virtual void paintCell (TQPainter *painter, int row, int col);
    virtual void mouseReleaseEvent (TQMouseEvent *e);
    virtual void resizeEvent (TQResizeEvent *e);

    int m_mouseButton;

protected slots:
    void slotColorSelected (int cell);
    void slotColorDoubleClicked (int cell);
};


class kpTransparentColorCell : public TQFrame
{
Q_OBJECT
  TQ_OBJECT

public:
    kpTransparentColorCell (TQWidget *parent, const char *name = 0);
    virtual ~kpTransparentColorCell ();

    virtual TQSize tqsizeHint () const;

signals:
    void transparentColorSelected (int mouseButton);

    // lazy
    void foregroundColorChanged (const kpColor &color);
    void backgroundColorChanged (const kpColor &color);

protected:
    virtual void mousePressEvent (TQMouseEvent *e);
    virtual void mouseReleaseEvent (TQMouseEvent *e);

    virtual void drawContents (TQPainter *p);

    TQPixmap m_pixmap;
};


class kpColorPalette : public TQWidget
{
Q_OBJECT
  TQ_OBJECT

public:
    kpColorPalette (TQWidget *parent,
                    Qt::Orientation o = Qt::Horizontal,
                    const char *name = 0);
    virtual ~kpColorPalette ();

    Qt::Orientation orientation () const;
    void setOrientation (Qt::Orientation o);

signals:
    void foregroundColorChanged (const kpColor &color);
    void backgroundColorChanged (const kpColor &color);

protected:
    Qt::Orientation m_orientation;

    TQBoxLayout *m_boxLayout;
    kpTransparentColorCell *m_transparentColorCell;
    kpColorCells *m_colorCells;
};


class kpColorSimilarityToolBarItem : public kpColorSimilarityCube
{
Q_OBJECT
  TQ_OBJECT

public:
    kpColorSimilarityToolBarItem (kpMainWindow *mainWindow,
                                  TQWidget *parent,
                                  const char *name = 0);
    virtual ~kpColorSimilarityToolBarItem ();

public:
    int processedColorSimilarity () const;

public slots:
    void setColorSimilarity (double similarity);

signals:
    void colorSimilarityChanged (double similarity, int processedSimilarity);

public:
    // (only valid in slots connected to colorSimilarityChanged());
    double oldColorSimilarity () const;

private:
    virtual void mousePressEvent (TQMouseEvent *e);
    virtual void mouseDoubleClickEvent (TQMouseEvent *e);

private:
    kpMainWindow *m_mainWindow;

    double m_oldColorSimilarity;
    int m_processedColorSimilarity;
};


class kpColorToolBar : public KToolBar
{
Q_OBJECT
  TQ_OBJECT

public:
    kpColorToolBar (const TQString &label, kpMainWindow *mainWindow, const char *name = 0);
    virtual ~kpColorToolBar ();

    kpColor color (int which) const;
    void setColor (int which, const kpColor &color);

    kpColor foregroundColor () const;
    kpColor backgroundColor () const;

    double colorSimilarity () const;
    void setColorSimilarity (double similarity);
    int processedColorSimilarity () const;

signals:
    // If you connect to this signal, ignore the following
    // foregroundColorChanged() and backgroundColorChanged() signals
    void colorsSwapped (const kpColor &newForegroundColor,
                        const kpColor &newBackgroundColor);

    void foregroundColorChanged (const kpColor &color);
    void backgroundColorChanged (const kpColor &color);
    void colorSimilarityChanged (double similarity, int processedSimilarity);

public:
    // (only valid in slots connected to foregroundColorChanged())
    kpColor oldForegroundColor () const;
    // (only valid in slots connected to backgroundColorChanged())
    kpColor oldBackgroundColor () const;

    // (only valid in slots connected to colorSimilarityChanged())
    double oldColorSimilarity () const;

public slots:
    void setForegroundColor (const kpColor &color);
    void setBackgroundColor (const kpColor &color);

private:
    kpMainWindow *m_mainWindow;

    Qt::Orientation m_lastDockedOrientation;
    bool m_lastDockedOrientationSet;
    virtual void setOrientation (Qt::Orientation o);

    TQBoxLayout *m_boxLayout;
    kpDualColorButton *m_dualColorButton;
    kpColorPalette *m_colorPalette;
    kpColorSimilarityToolBarItem *m_colorSimilarityToolBarItem;
};

#endif  // __kp_color_toolbar_h__
