/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <kdeprint@swing.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#include "kmwdriver.h"
#include "kmwizard.h"
#include "kmprinter.h"
#include "kmdriverdbwidget.h"
#include "kmdriverdb.h"

#include <tqlayout.h>
#include <klocale.h>

KMWDriver::KMWDriver(TQWidget *parent, const char *name)
: KMWizardPage(parent,name)
{
	m_ID = KMWizard::Driver;
	m_title = i18n("Printer Model Selection");
	m_nextpage = KMWizard::DriverTest;

	m_widget = new KMDriverDbWidget(this);

	TQVBoxLayout	*lay1 = new TQVBoxLayout(this, 0, 0);
	lay1->addWidget(m_widget);
}

void KMWDriver::initPrinter(KMPrinter *p)
{
	m_widget->init();
	if (p)
	{
		TQString autoDetect = p->option( "kde-autodetect" );
		if ( !autoDetect.isEmpty() )
		{
			// use auto-detection info instead: split the string
			// into make/model pair at the first space character
			int p = autoDetect.find( ' ' );
			if ( p != -1 )
			{
				TQString manu = autoDetect.left( p ), model = autoDetect.mid( p+1 );
				KMDBEntryList *l = KMDriverDB::self()->findPnpEntry( manu, model );
				if ( l && l->count() > 0 )
				{
					m_widget->setDriver( l->getFirst()->manufacturer, l->getFirst()->model );
					return;
				}
			}
		}
		m_widget->setDriver(p->manufacturer(),p->model());
	}
}

void KMWDriver::updatePrinter(KMPrinter *p)
{
	if (p)
	{
		p->setManufacturer(TQString::null);
		p->setModel(TQString::null);
		p->setDbEntry(0);
		p->setDriverInfo(TQString::null);
		p->setOption("kde-driver",TQString::null);
		setNextPage(KMWizard::DriverTest);
		if (m_widget->isRaw())
		{
			p->setDriverInfo(i18n("Raw printer"));
			p->setOption("kde-driver","raw");
		}
		else
		{
			p->setManufacturer(m_widget->manufacturer());
			p->setModel(m_widget->model());
			if (m_widget->isExternal())
			{
				p->setDriverInfo(m_widget->description());
				p->setOption("kde-driver",m_widget->driverFile());
			}
			else
			{
				KMDBEntryList	*drvs = m_widget->drivers();
				if (drvs->count() == 1)
				{
					p->setDbEntry(drvs->getFirst());
					p->setDriverInfo(drvs->getFirst()->description);
				}
				else
					setNextPage(KMWizard::DriverSelect);
			}
		}
	}
}

bool KMWDriver::isValid(TQString& msg)
{
	if (m_widget->isRaw() || m_widget->isExternal() || m_widget->drivers())
		return true;
	else
	{
		msg = i18n("Internal error: unable to locate the driver.");
		return false;
	}
}
